/*
 * Decompiled with CFR 0.152.
 */
package notryken.effecttimerplus.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import notryken.effecttimerplus.EffectTimerPlus;
import notryken.effecttimerplus.util.MiscUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    public static final String DEFAULT_FILE_NAME = "effecttimerplus.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final float DEFAULT_SCALE = 1.0f;
    public static final int DEFAULT_COLOR = -1711276033;
    public static final int DEFAULT_BACK_COLOR = -1776213727;
    public static final int DEFAULT_WARN_COLOR = -65536;
    public static final int DEFAULT_WARN_TIME = 20;
    public static final int DEFAULT_POTENCY_LOCATION = 2;
    public static final int DEFAULT_COUNTDOWN_LOCATION = 6;
    private static Path configPath;
    private final int version = 1;
    public double scale = 1.0;
    public boolean potencyEnabled = true;
    public boolean timerEnabled = true;
    public boolean timerEnabledAmbient = false;
    public boolean timerWarnEnabled = true;
    public boolean timerFlashEnabled = true;
    private int timerWarnTime = 20;
    private int potencyColor = -1711276033;
    private int potencyBackColor = -1776213727;
    private int timerColor = -1711276033;
    private int timerWarnColor = -65536;
    private int timerBackColor = -1776213727;
    private int potencyLocation = 2;
    private int timerLocation = 6;

    public int getTimerWarnTime() {
        return this.timerWarnTime;
    }

    public void setTimerWarnTime(int time) {
        this.timerWarnTime = time < 0 ? 20 : time;
    }

    public int getPotencyColor() {
        return this.potencyColor;
    }

    public void setPotencyColor(int color) {
        this.potencyColor = this.adjustColor(color);
    }

    public int getPotencyBackColor() {
        return this.potencyBackColor;
    }

    public void setPotencyBackColor(int color) {
        this.potencyBackColor = this.adjustColor(color);
    }

    public int getTimerColor() {
        return this.timerColor;
    }

    public void setTimerColor(int color) {
        this.timerColor = this.adjustColor(color);
    }

    public int getTimerBackColor() {
        return this.timerBackColor;
    }

    public void setTimerBackColor(int color) {
        this.timerBackColor = this.adjustColor(color);
    }

    public int getTimerWarnColor() {
        return this.timerWarnColor;
    }

    public void setTimerWarnColor(int color) {
        this.timerWarnColor = this.adjustColor(color);
    }

    public int getPotencyLocation() {
        return this.potencyLocation;
    }

    public void setPotencyLocation(int locIndex) {
        this.potencyLocation = locIndex;
    }

    public int getTimerLocation() {
        return this.timerLocation;
    }

    public void setTimerLocation(int locIndex) {
        this.timerLocation = locIndex;
    }

    private int adjustColor(int color) {
        if (MiscUtil.toAlpha.applyAsInt(color) < 4) {
            return MiscUtil.withAlpha.applyAsInt(color, MiscUtil.fromAlpha.applyAsInt(4));
        }
        return color;
    }

    private void validate() {
        this.setTimerWarnTime(this.timerWarnTime);
        this.setPotencyColor(this.potencyColor);
        this.setPotencyBackColor(this.potencyBackColor);
        this.setTimerColor(this.timerColor);
        this.setTimerBackColor(this.timerBackColor);
        this.setTimerWarnColor(this.timerWarnColor);
        this.setPotencyLocation(this.potencyLocation);
        this.setTimerLocation(this.timerLocation);
    }

    public void resetPotencyConfig() {
        this.potencyEnabled = true;
        this.potencyColor = -1711276033;
        this.potencyBackColor = -1776213727;
        this.potencyLocation = 2;
    }

    public void resetTimerConfig() {
        this.timerEnabled = true;
        this.timerEnabledAmbient = false;
        this.timerWarnEnabled = true;
        this.timerFlashEnabled = true;
        this.timerWarnTime = 20;
        this.timerColor = -1711276033;
        this.timerWarnColor = -65536;
        this.timerBackColor = -1776213727;
        this.timerLocation = 2;
    }

    @NotNull
    public static Config load() {
        Config config = Config.load(DEFAULT_FILE_NAME);
        if (config == null) {
            EffectTimerPlus.LOG.info("Using default configuration.", new Object[0]);
            config = new Config();
        }
        config.writeToFile();
        return config;
    }

    @Nullable
    public static Config load(String name) {
        configPath = Path.of("config", new String[0]).resolve(name);
        Config config = null;
        if (Files.exists(configPath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(configPath.toFile());){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (Exception e) {
                EffectTimerPlus.LOG.error("Unable to load config from file '{}'.", configPath, e);
            }
        } else {
            EffectTimerPlus.LOG.warn("Unable to locate config file '{}'.", name);
        }
        return config;
    }

    public void writeToFile() {
        Path dir = configPath.getParent();
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            } else if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new IOException("Not a directory: " + dir);
            }
            Path tempPath = configPath.resolveSibling(configPath.getFileName() + ".tmp");
            Files.writeString(tempPath, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
            Files.move(tempPath, configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to update config file", e);
        }
    }
}

